<?php

namespace Rapbit\Base\Tests\Unit\Util;
use PHPUnit\Framework\TestCase;
use Rapbit\Base\Util\LogFormatter;
use Rapbit\Base\Util\StringUtil;

class StringUtilTest extends TestCase
{
    public function testSlugify(): void
    {
        $this->assertSame('hello-world', StringUtil::slugify('Hello World'));
        $this->assertSame('multiple-spaces', StringUtil::slugify('  Multiple   Spaces  '));
        $this->assertSame('with-numbers-123', StringUtil::slugify('With numbers 123!!'));
    }
}
