<?php
namespace Rapbit\Base\Tests\Classes;

use GuzzleHttp\Client;
use PHPUnit\Framework\TestCase;
use Psr\Http\Message\ResponseInterface;
use Rapbit\Base\Constant\HttpMethod;
use Rapbit\Base\Contract\ContainerInterface;
use Rapbit\Base\Http\Json;
use Symfony\Component\Process\Process;
use CPP\CMS\Rapbit;

class AbstractFunctionalTest extends TestCase
{
    protected static ?ContainerInterface $container = null;
    protected static ?Process $process = null;
    protected static ?Client $client = null;

    public static function setUpBeforeClass(): void
    {
        parent::setUpBeforeClass();
        if (self::$process === null){
            $host = "127.0.0.1";// getenv("TEST_HOSTNAME") ?? "localhost";
            $port = 8090;//(int)(getenv("TEST_PORT") ?? "8092");
            $command = sprintf("%s -S %s:%d -t %s",
                "php", //getenv("PHP_LOCATION") ?? "php",
                $host,
                $port,
                realpath(getcwd() . "/example-final-implementation/public"), //realpath(getenv("TEST_DOCROOT") ?? "./public"),
            );
            self::$process = Process::fromShellCommandline($command);
            self::$process->start();

            usleep(1000000); //1sec
            self::$client = new Client([
                "base_uri" => sprintf("http://%s:%d", $host, $port),
                "timeout" => 2.0
            ]);
        }
    }

    public static function tearDownAfterClass(): void
    {
        parent::tearDownAfterClass();
        if (self::$process){
            self::$process->stop();
            self::$process = null;
            self::$client = null;
        }
    }

    public function request(
        string $endpoint,
        string $method = HttpMethod::GET,
        array $body = [],
        array $headers = []
    ): ResponseInterface
    {
        if (!array_key_exists("Content-Type", $headers)){
            $headers["Content-Type"] = "application/json";
        }
        $response = self::$client->request(
            $method,
            $endpoint,
            [
                "headers" => $headers,
                "json" => $body
            ]
        );

        return new Json($response->getStatusCode(), json_decode($response->getBody()->__toString(), true) ?? [], $response->getHeaders());
    }
}