<?php

namespace Rapbit\Base\Util;

use GuzzleHttp\Psr7\Utils;
use Psr\Http\Message\StreamInterface;

final class StringUtil
{
    public static function slugify(string $value): string
    {
        $value = strtolower(trim($value));
        $value = preg_replace('/[^a-z0-9]+/i', '-', $value) ?? '';
        return trim($value, '-');
    }

    public static function stringToStream(string $string): StreamInterface
    {
        return Utils::streamFor($string);
    }
}
