<?php
namespace Rapbit\Base\Service;

use Cycle\Annotated\Locator\Entity;
use Cycle\ORM\EntityManager;
use Cycle\ORM\ORMInterface;
use Rapbit\Base\Constant\Rapbit;
use Rapbit\Base\Contract\ContainerInterface;
use Rapbit\Base\Contract\FactoryBasedService;
use Rapbit\Base\Contract\ServiceInterface;

class Container implements ContainerInterface, FactoryBasedService
{
    /**
     * The single instance of the class.
     */
    private static ?self $instance = null;

    /**
     * Private constructor to prevent direct instantiation.
     */
    private function __construct(private array $services = [])
    {
    }

    public function getEnv(): string
    {
        return $this->get('config')->get(Rapbit::KEY_ENVIRONMENT);
    }

    /**
     * Prevent cloning of the instance.
     */
    private function __clone()
    {
    }

    /**
     * Prevent unserialization of the instance.
     */
    public function __wakeup()
    {
    }

    /**
     * Get the single instance of the class.
     */
    public static function getInstance(): static
    {
        if (self::$instance === null) {
            self::$instance = new static();
        }
        // As of PHP 7.4+, this can be shortened using the null coalescing operator:
        // static $instance;
        // return $instance ??= new static();

        return self::$instance;
    }

    /**
     * @param string $serviceName key for the service
     *
     * @return mixed Rapbit\Base\Contract\ServiceInterface preferred but have to support external (ie Cycle ORM)
     */
    public function get(string $serviceName): mixed
    {
        return $this->services[$serviceName];
    }

    /**
     * @param string $serviceName key for the service
     * @param mixed $service Rapbit\Base\Contract\ServiceInterface preferred but have to support external (ie Cycle ORM)
     */
    public function add(string $serviceName, mixed $service): static
    {
        $this->services[$serviceName] = $service;
        return $this;
    }

    public function getEm(): EntityManager
    {
        /** @var ORMInterface $orm */
        $orm = $this->get('orm');

        return new EntityManager($orm);
    }
}
