<?php
namespace Rapbit\Base\Service;

use Rapbit\Base\Constant\Rapbit;
use Rapbit\Base\Contract\FactoryBasedService;
use Rapbit\Base\Error\DataNotFoundException;

readonly class Config implements FactoryBasedService
{
    public function __construct(private array $data){}

    public function getProjectRoot(): string
    {
        if (array_key_exists(Rapbit::KEY_PROJECT_ROOT, $this->data)){
            return $this->data[Rapbit::KEY_PROJECT_ROOT];
        }
        $path =  realpath(getcwd() . "../"); // assuming module in vendor but since called from bootstrap folder...
        if (empty($path)){
            $path = realpath(getcwd() . "../../");
        }
        if (empty($path)){
            $path = getcwd();
        }
        return $path;
    }

    public function get(?string $key = null, bool $exceptionOnNotFound = true, mixed $default = null){
        if (is_null($key)){
            return $this->data;
        }

        if ($exceptionOnNotFound && !array_key_exists($key, $this->data)){
            throw new DataNotFoundException($key);
        }
        return $this->data[$key] ?? $default;
    }

}