<?php
namespace Rapbit\Base\Factory;

use Rapbit\Base\Contract\ContainerInterface;
use Rapbit\Base\Contract\FactoryBasedService;
use Rapbit\Base\Contract\ServiceFactoryInterface;
use Rapbit\Base\Error\ApplicationError;
use Rapbit\Base\Service\Container;

class ContainerFactory implements ServiceFactoryInterface
{
    public function __construct(){
    }

    public function create(): FactoryBasedService
    {
        return Container::getInstance();
    }

    public static function createContainer(array $services): FactoryBasedService|ContainerInterface
    {
        $cf = new ContainerFactory();
        /** @var Container $container */
        $container = $cf->create();
        foreach($services as $name => $instance){
            $container->add($name, $instance);
        }
        return $container;
    }
}