<?php
namespace Rapbit\Base\Factory;

use Dotenv\Dotenv;
use Rapbit\Base\Contract\FactoryBasedService;
use Rapbit\Base\Contract\ServiceFactoryInterface;
use Rapbit\Base\Error\ApplicationError;
use Rapbit\Base\Service\Config;

class ConfigFactory implements ServiceFactoryInterface
{
    public function __construct(private ?string $filePath = null, private ?array $data = null){
        if (is_null($this->filePath) && is_null($this->data)){
            throw new ApplicationError("Must have either path or data");
        }
    }

    public function create(): FactoryBasedService
    {
        if ($this->filePath){
            $raw = parse_ini_file($this->filePath);
            $dotenv = Dotenv::createImmutable(dirname($this->filePath));
            $dotenv->load();
        } else {
            $raw = $this->data;
        }
        $env = array_merge($raw, $_ENV);
        return new Config($env);
    }

    public static function createConfig(string $filePath): FactoryBasedService|Config
    {
        $cf = new ConfigFactory(filePath: $filePath);
        return $cf->create();
    }

    public static function createConfigFromData(array $data): FactoryBasedService|Config
    {
        $cf = new ConfigFactory(data: $data);
        return $cf->create();
    }
}