<?php
namespace Rapbit\Base\Error;

final class DataNotFoundException extends \Exception
{
    public function __construct(?string $key = null, int $code = 0, ?\Throwable $previous = null)
    {
        if (is_null($key)){
            $message = "Data not found";
        } else {
            $message = sprintf("`%s` not found", $key);
        }
        parent::__construct($message, $code, $previous);
    }
}