<?php
namespace Rapbit\Base\Error;

final class ApplicationError extends \Error
{
    public function __construct(string $originalErrorMessage, array $extra = [], int $code = 599, ?\Throwable $previous = null)
    {
        $messages = array_merge(["App Error: " . $originalErrorMessage], $extra);
        $message = json_encode($messages, JSON_PRETTY_PRINT);
        parent::__construct($message, $code, $previous);
    }
}