<?php
namespace Rapbit\Base\Abstracts;

use Psr\Http\Message\ResponseInterface;
use Rapbit\Base\Contract\ContainerInterface;
use Rapbit\Base\Http\Json;
use Rapbit\Logging\Contract\LogLevel;

abstract class Controller
{
    public function __construct(
        private ContainerInterface $container
    ) {
    }

    protected function getContainer(): ContainerInterface
    {
        return $this->container;
    }

    protected function log(string $message, array $context = [], LogLevel $level = LogLevel::DEBUG): void
    {
        $this->container->get('logger')->log($level, $message, $context);
    }

    protected function respond(array $data = [], int $status = 200, array $extraHeaders = []): ResponseInterface
    {
        return new Json($status, $data, $extraHeaders);
    }
}