<?php
declare(strict_types=1);

namespace CPP\Base\Tests\Functional;

use CPP\Base\Factory\ApiClientFactory;
use CPP\Base\Http\IdLocation;
use CPP\Base\Http\ResourceClient;
use PHPUnit\Framework\TestCase;
use Rapbit\Base\Service\Config;
use Rapbit\Base\Error\ApplicationError;

final class ApiSmokeTest extends TestCase
{
    private function configFromEnv(): Config
    {
        // Feed Config directly with env array (no Dotenv needed)
        return new Config($_ENV); // aligns with your Config service signature
    }

    public function testListOnLiveService(): void
    {
        $baseUrl = getenv('SMOKE_BASE_URL');
        $path    = getenv('SMOKE_RESOURCE_PATH');

        if (!$baseUrl || !$path) {
            $this->markTestSkipped('Set SMOKE_BASE_URL and SMOKE_RESOURCE_PATH to run this smoke test.');
        }

        // Try to use Guzzle factories if present; otherwise skip
        if (!class_exists(\GuzzleHttp\Client::class) || !class_exists(\GuzzleHttp\Psr7\HttpFactory::class)) {
            $this->markTestSkipped('Guzzle client or HttpFactory not installed for smoke test.');
        }

        $cfg = $this->configFromEnv();

        // Provide the base URL key dynamically for the factory
        $_ENV['SMOKE_BASE_URL'] = $baseUrl;

        $client = ApiClientFactory::createFrom(
            config: $cfg,
            httpClient: new \GuzzleHttp\Client(),
            requestFactory: new \GuzzleHttp\Psr7\HttpFactory(),
            streamFactory: new \GuzzleHttp\Psr7\HttpFactory(),
            baseUrlKey: 'SMOKE_BASE_URL'
        );

        $idLoc = strtolower((string) (getenv('SMOKE_ID_LOCATION') ?: 'query'));
        $idQueryName = (string) (getenv('SMOKE_ID_QUERY_NAME') ?: 'id');

        $rc = new ResourceClient(
            $client,
            $path,
            $idLoc === 'path' ? IdLocation::PathSegment : IdLocation::QueryParam,
            $idQueryName
        );

        // Basic list() call – should not throw
        $list = $rc->list();
        $this->assertIsArray($list);
    }
}