<?php
declare(strict_types=1);

namespace CPP\Base\Contract;

use Psr\Http\Message\ResponseInterface;

interface ApiClientInterface
{
    /**
     * @param array<string,mixed>|string|null $body
     * @param array<string,string|string[]>   $headers
     */
    public function request(
        string $path,
        string $method = 'GET',
        array $query = [],
        array|string|null $body = null,
        array $headers = []
    ): ResponseInterface;
}