<?php
declare(strict_types=1);

namespace CPP\Base\Auth;

use CPP\Base\Contract\AuthenticatorInterface;
use Psr\Http\Message\RequestInterface;

final class BearerTokenAuthenticator implements AuthenticatorInterface
{
    public function __construct(private readonly string $token) {}

    public function authenticate(RequestInterface $request): RequestInterface
    {
        return $request->withHeader('Authorization', 'Bearer ' . $this->token);
    }
}