<?php
declare(strict_types=1);

namespace CPP\Base\Auth;

use CPP\Base\Contract\AuthenticatorInterface;
use Psr\Http\Message\RequestInterface;

final class BasicAuthenticator implements AuthenticatorInterface
{
    public function __construct(
        private readonly string $username,
        private readonly string $password
    ) {}

    public function authenticate(RequestInterface $request): RequestInterface
    {
        $value = base64_encode($this->username . ':' . $this->password);
        return $request->withHeader('Authorization', 'Basic ' . $value);
    }
}