<?php
declare(strict_types=1);

namespace CPP\Base\Auth;

use CPP\Base\Contract\AuthenticatorInterface;
use Psr\Http\Message\RequestInterface;

enum ApiKeyLocation: string
{
    case Header = 'header';
    case Query  = 'query';
}

final class ApiKeyAuthenticator implements AuthenticatorInterface
{
    public function __construct(
        private readonly string $key,
        private readonly string $name = 'X-API-Key',
        private readonly ApiKeyLocation $in = ApiKeyLocation::Header
    ) {}

    public function authenticate(RequestInterface $request): RequestInterface
    {
        return match ($this->in) {
            ApiKeyLocation::Header => $request->withHeader($this->name, $this->key),
            ApiKeyLocation::Query  => $this->withQuery($request, [$this->name => $this->key]),
        };
    }

    private function withQuery(RequestInterface $request, array $params): RequestInterface
    {
        $uri   = $request->getUri();
        parse_str($uri->getQuery(), $current);
        $new   = http_build_query(array_merge($current, $params));
        $newUri = $uri->withQuery($new);
        return $request->withUri($newUri);
    }
}